import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Descriptive statistics for credit history  
credit_history_column = credit_customers['credit_history']
credit_history_counts = count_unique_values(credit_history_column) 

print("\nCredit History Distribution:")  
print(credit_history_counts)  
pickle.dump(credit_history_counts,open("./ref_result/credit_history_counts.pkl","wb"))